// background.js

// Listen to clicks on the extension icon
chrome.action.onClicked.addListener((tab) => {
    if (!tab || !tab.id || !tab.url) {
        return;
    }

    let isFreepik = false;

    try {
        const urlObj = new URL(tab.url);
        const host = urlObj.hostname; // e.g. "de.freepik.com"

        // Match freepik.com and any subdomain like de.freepik.com, www.freepik.com, etc.
        isFreepik =
            host === "freepik.com" ||
            host.endsWith(".freepik.com");
    } catch (e) {
        isFreepik = false;
    }

    chrome.scripting.executeScript({
        target: { tabId: tab.id },
        func: injectedSendToPicodl,
        args: [isFreepik]
    });
});

/**
 * This function runs inside the page context.
 * It extracts the og:image URL from the current Freepik page
 * and sends it to picodl.com via a POST form.
 */
function injectedSendToPicodl(isFreepikTab) {
    // Only work on freepik.com pages
    if (!isFreepikTab) {
        alert("This extension only works on freepik.com pages.");
        return;
    }

    // Try to find the <meta property="og:image" ...> tag
    const meta = document.querySelector('meta[property="og:image"]');
    if (!meta) {
        alert("No og:image meta tag found on this page.");
        return;
    }

    const imageUrl = meta.getAttribute("content") || "";
    if (!imageUrl) {
        alert("og:image meta tag has no content.");
        return;
    }

    // Create a form to POST the image URL to picodl.com
    const form = document.createElement("form");
    form.method = "POST";
    form.action = "https://picodl.com/downloader.php";
    form.target = "_blank"; // Open result in a new tab

    // Hidden input: 'image_url'
    const input = document.createElement("input");
    input.type = "hidden";
    input.name = "image_url";    // Matches your PHP parameter
    input.value = imageUrl;      // Send the image URL itself

    form.appendChild(input);
    document.body.appendChild(form);

    // Submit the form
    form.submit();

    // Clean up
    form.remove();
}

